/******************************************************************************
 * Copyright (c) 2005 palmOne, Inc. or its subsidiaries.
 * All rights reserved.
 *****************************************************************************/
/**
 *@ingroup System
 *
 */

/**
 * @file 	palmOneResources.h
 * @version 1.0
 *
 * @brief Palm-specific system types and resources.
 *
 * <hr>
 */

#ifndef __PALMONERESOURCES_H__
#define	__PALMONERESOURCES_H__

// Feature: sysFtrNumOEMCompanyID
/**
 * @name Company ID - registered creator
 *
 */
/*@{*/
#define kPalmCompanyIDPalm			'Palm'	/**< Company ID. */
#define kPalmCompanyIDOldPalm		'palm'	/**< Old company ID. For Tungsten|W. */
/*@}*/


// Feature: sysFtrNumOEMDeviceID
/**
 * @name Device ID - registered creator
 *
 */
/*@{*/
#define kPalmOneDeviceIDZire		'Cubs'	/**< Device ID for Zire. */
#define kPalmOneDeviceIDTungstenT	'Frg1'	/**< Device ID for Tungsten|T. */
#define kPalmOneDeviceIDTungstenW	'atlc'	/**< Device ID for Tungsten|W. */
#define kPalmOneDeviceIDTungstenC	'MT64'	/**< Device ID for Tungsten|C. */
#define kPalmOneDeviceIDZire71		'Zpth'	/**< Device ID for Zire71. */
#define kPalmOneDeviceIDTungstenT2	'Frg2'  /**< Device ID for Tungsten|T2. */
#define kPalmOneDeviceIDTungstenT3	'Arz1'	/**< Device ID for Tungsten|T3. */
#define kPalmOneDeviceIDTungstenTE	'Cct1'	/**< Device ID for Tungsten|E. */
#define kPalmOneDeviceIDZire21		'Zi21'	/**< Device ID for Zire21. */
#define kPalmOneDeviceIDTreo600		'H101'	/**< Device ID for Treo600. */
#define kPalmOneDeviceIDTreo600Sim	'H201'	/**< Device ID for Treo600 Simulator. */
#define kPalmOneDeviceIDZire31		'Zi22'	/**< Device ID for Zire31. */
#define kPalmOneDeviceIDZire72		'Zi72'	/**< Device ID for Zire72. */
#define kPalmOneDeviceIDAngus		'TnT5'	/**< Device ID for Tungsten|T5. */
#define kPalmOneDeviceIDTungstenT5	kPalmOneDeviceIDAngus	/**< Device ID for Tungsten|T5. */
#define kPalmOneDeviceIDTreo650		'H102'	/**< Device ID for Treo650. */
#define kPalmOneDeviceIDTreo650Sim	'H202'	/**< Device ID for Treo650 Simulator. */
#define kPalmOneDeviceIDTungstenX	'TunX'	/**< Device ID for LifeDrive */
#define kPalmDeviceIDTX				'D050'	/**< Device ID for Palm T|X */
#define kPalmDeviceIDZ22			'D051'	/**< Device ID for Palm Z22 */
/*@}*/

#endif // __PALMONERESOURCES_H__
